define([
		'app',
		'UnauthorizedController',
		'AssessmentBuilderListViewController',
		'AssessmentBuilderEditController',
		'AssessmentDescriptionModalController',
		'DeleteQuestionModalController',
		'PublishAssessmentModalController',
		'DeleteAssessmentModalController',
		'InactivateAssessmentModalController',
		'ModifyAssessmentModalController',
		'assessmentService',
		'AssessmentErrorService',
		'assessmentModels'
	],
	function (app) {
		'use strict';

		var AUTHORIZED_STATE = 'main.auth.one-panel.assessment-builder';

		app.config(function ($stateProvider, $urlRouterProvider) {
			$stateProvider
				.state(AUTHORIZED_STATE, {
					abstract: true,
					data: {
							homeName: 'VA Tool Set Home',
							moduleName: 'Assessment Builder',
							baseStateName : AUTHORIZED_STATE
						},
					resolve : {
						// NOTE: for staff-side only, ensures mhpuser has been fetched in router instead of in localResourceDirectoryService
						authorization: function ($q, pageService, authenticationService, mhpuser, $state, $http, assessmentService, AssessmentErrorService) {
							var defer = $q.defer();

                            mhpuser.fetch().then(function(result){
                                assessmentService.authorize().then(function(isAuthorized) {
                                    if (isAuthorized) {
                                        defer.resolve();
                                    } else {
                                        defer.reject({ error: 'assessment-builder.unauthorized'});
                                    }
                                }, function(errorResponse) {
                                    defer.reject({error: 'assessment-builder.unauthorized'});
                                });
                            }, function(error) {
                                defer.reject();
                            });

							return defer.promise;
						}
					}
				})
				.state(AUTHORIZED_STATE + '.list', {
					url: '/assessment-builder',
					views : {
						'primary@main.auth.one-panel': {
							templateUrl: 'src/modules/assessment-builder/pages/assessment-builder-list-view_template.html',
							controller: 'AssessmentBuilderListViewController'
						}
					}
				})
				.state(AUTHORIZED_STATE + '.edit', {
					url: '/edit/:id',
					params: {
						assessment: null
					},
					views : {
						'primary@main.auth.one-panel': {
							templateUrl: 'src/modules/assessment-builder/pages/assessment-builder-edit_template.html',
							controller: 'AssessmentBuilderEditController'
						}
					}
				});
		});
	}
);
